

/******************************************************************************************************
 **                                                                                                  **
 **                            Ex3 : Display Text on ET-DSP I2C LED 16x8                             **
 **                                                                                                  **
 ******************************************************************************************************
 **                                                                                                  **
 **  Target MCU         : Arduino Mega32U4  (ET-Base AVR EASY32U4 LEONADO)                           **
 **                     : X-TAL : 16 MHz                                                             ** 
 **                                                                                                  **
 **  Editor/Compiler    : Arduino 1.8.12                                                             **
 **                                                                                                  **                   
 **  Port Interface     :    Arduino Easy328                         ET-DSP I2C LED16x2              **
 **                         -----------------                       --------------------             **
 **    I2C HT16K33      :  PIN D2-SDA            Connect             SDA                             **                                                                                    
 **                            D3-SCL            Connect             SCL                             **
 **                                                                 I2C Address=0x70                 **
 **                                                                                                  **
 **                                                                                                  **                                                                                                 
 **  Operate : Display Text and String                                                               ** 
 **                                                                                                  **
 **  Create By          : Mr. Sittiphol Yooyod (WWW.ETTEAM.COM)                                      **
 **  Last Update        : 31/October/2020                                                            ** 
 **                                                                                                  ** 
 **                                 ==== ET-DSP I2C LED 16x2 ====                                    ** 
 **                          [axis-Y=0-7]                                                            **                                   
 **                              ^                                                                   **
 **                        Row   | Even Address       Odd Address --->    Colum                      **
 **                   (D7) ay7   o o o o o o o o    o o o o o o o o                                  ** 
 **                         ^    o             o    o             o                                  ** 
 **                         |    o             o    o             o                                  **
 **                         |    o             o    o             o                                  ** 
 **                         |    o             o    o             o                                  **
 **                         |    o             o    o             o                                  **
 **                         |    o             o    o             o                                  **  
 **                   (D0) ay0   o o o o o o o o    o o o o o o o o  ----->   [axis-x=0-15]          **
 **                             ax0           ax7  ax8            ax15                               **         
 **                                                                                                  **
 ******************************************************************************************************/


#include <Wire.h>



/******************************************************
 *                                                    *
 *       Font 5x7(English)                            *
 *                                                    *
 ******************************************************
 * -ASCII fonts from 0x20 ~ 0x7F(DEC 32 ~ 127)        *
 *  composed of following characters                  *
 *                                                    * 
 * -XSize : 5  pixcels (Array 5byte 0-->4)            *
 * -YSize : 7  pixcels (Array 1 Byte)                 *
 *                                                    *
 *                                                    *
 *   End  ..OOOOO.. <- bit7       (y)                 *
 *    ^   ..OOOOO.. <- bit6        ^                  *
 *    |   ..OOOOO.. <- bit5        |                  *
 *    |   ..OOOOO.. <- bit4        |                  *
 *    |   ..OOOOO.. <- bit3        |                  *
 *    |   ..OOOOO.. <- bit2        |                  *
   Start  ..OOOOO.. <- bit1       +----->(x)          *                 
 *        ..OOOOO.. <- bit0  (Blank,Not Use)          *
 *                                                    *   
 *  Byte0-----------> Byte4                           *
 *                                                    *
 *     (O = 1 Byte Array  in Table)                   *
 *     (1 Charecter = 5 byte)                         *
 ******************************************************/

const unsigned char font_5x7[96][5] PROGMEM = {
        {0x00,0x00,0x00,0x00,0x00}, //
        {0x00,0x00,0xfa,0x00,0x00}, // !
        {0x00,0xe0,0x00,0xe0,0x00}, // "
        {0x28,0xfe,0x28,0xfe,0x28}, // #
        {0x24,0x54,0xfe,0x54,0x48}, // $
        {0xc4,0xc8,0x10,0x26,0x46}, // %
        {0x6c,0x92,0xaa,0x44,0x0a}, // &
        {0x00,0xa0,0xc0,0x00,0x00}, // '
        {0x00,0x38,0x44,0x82,0x00}, // (
        {0x00,0x82,0x44,0x38,0x00}, // )
        {0x10,0x54,0x38,0x54,0x10}, // *
        {0x10,0x10,0x7c,0x10,0x10}, // +
        {0x00,0x0a,0x0c,0x00,0x00}, // ,
        {0x10,0x10,0x10,0x10,0x10}, // -
        {0x00,0x06,0x06,0x00,0x00}, // .
        {0x04,0x08,0x10,0x20,0x40}, // /
        {0x7c,0x8a,0x92,0xa2,0x7c}, // 0
        {0x22,0x42,0xfe,0x02,0x02}, // 1
        {0x42,0x86,0x8a,0x92,0x62}, // 2
        {0x84,0x82,0xa2,0xd2,0x8c}, // 3
        {0x18,0x28,0x48,0xfe,0x08}, // 4
        {0xe4,0xa2,0xa2,0xa2,0x9c}, // 5
        {0x3c,0x52,0x92,0x92,0x0c}, // 6
        {0x80,0x8e,0x90,0xa0,0xc0}, // 7
        {0x6c,0x92,0x92,0x92,0x6c}, // 8
        {0x60,0x92,0x92,0x94,0x78}, // 9
        {0x00,0x6c,0x6c,0x00,0x00}, // :
        {0x00,0x6a,0x6c,0x00,0x00}, // ;
        {0x00,0x10,0x28,0x44,0x82}, // <
        {0x28,0x28,0x28,0x28,0x28}, // =
        {0x82,0x44,0x28,0x10,0x00}, // >
        {0x40,0x80,0x8a,0x90,0x60}, // ?
        {0x4c,0x92,0x9e,0x82,0x7c}, // @
        {0x7e,0x88,0x88,0x88,0x7e}, // A
        {0xfe,0x92,0x92,0x92,0x6c}, // B
        {0x7c,0x82,0x82,0x82,0x44}, // C
        {0xfe,0x82,0x82,0x44,0x38}, // D
        {0xfe,0x92,0x92,0x92,0x82}, // E
        {0xfe,0x90,0x90,0x80,0x80}, // F
        {0x7c,0x82,0x82,0x8a,0x4c}, // G
        {0xfe,0x10,0x10,0x10,0xfe}, // H
        {0x00,0x82,0xfe,0x82,0x00}, // I
        {0x04,0x02,0x82,0xfc,0x80}, // J
        {0xfe,0x10,0x28,0x44,0x82}, // K
        {0xfe,0x02,0x02,0x02,0x02}, // L
        {0xfe,0x40,0x20,0x40,0xfe}, // M
        {0xfe,0x20,0x10,0x08,0xfe}, // N
        {0x7c,0x82,0x82,0x82,0x7c}, // O
        {0xfe,0x90,0x90,0x90,0x60}, // P
        {0x7c,0x82,0x8a,0x84,0x7a}, // Q
        {0xfe,0x90,0x98,0x94,0x62}, // R
        {0x62,0x92,0x92,0x92,0x8c}, // S
        {0x80,0x80,0xfe,0x80,0x80}, // T
        {0xfc,0x02,0x02,0x02,0xfc}, // U
        {0xf8,0x04,0x02,0x04,0xf8}, // V
        {0xfe,0x04,0x18,0x04,0xfe}, // W
        {0xc6,0x28,0x10,0x28,0xc6}, // X
        {0xc0,0x20,0x1e,0x20,0xc0}, // Y
        {0x86,0x8a,0x92,0xa2,0xc2}, // Z
        {0x00,0x00,0xfe,0x82,0x82}, // [
        {0x40,0x20,0x10,0x08,0x04}, // "\"
        {0x82,0x82,0xfe,0x00,0x00}, // ]
        {0x20,0x40,0x80,0x40,0x20}, // ^
        {0x02,0x02,0x02,0x02,0x02}, // _
        {0x00,0x80,0x40,0x20,0x00}, // `
        {0x04,0x2a,0x2a,0x2a,0x1e}, // a
        {0xfe,0x12,0x22,0x22,0x1c}, // b
        {0x1c,0x22,0x22,0x22,0x04}, // c
        {0x1c,0x22,0x22,0x12,0xfe}, // d
        {0x1c,0x2a,0x2a,0x2a,0x18}, // e
        {0x10,0x7e,0x90,0x80,0x40}, // f
        {0x10,0x28,0x2a,0x2a,0x3c}, // g
        {0xfe,0x10,0x20,0x20,0x1e}, // h
        {0x00,0x22,0xbe,0x02,0x00}, // i
        {0x04,0x02,0x22,0xbc,0x00}, // j
        {0x00,0xfe,0x08,0x14,0x22}, // k
        {0x00,0x82,0xfe,0x02,0x00}, // l
        {0x3e,0x20,0x18,0x20,0x1e}, // m
        {0x3e,0x10,0x20,0x20,0x1e}, // n
        {0x1c,0x22,0x22,0x22,0x1c}, // o
        {0x3e,0x28,0x28,0x28,0x10}, // p
        {0x10,0x28,0x28,0x18,0x3e}, // q
        {0x3e,0x10,0x20,0x20,0x10}, // r
        {0x12,0x2a,0x2a,0x2a,0x04}, // s
        {0x20,0xfc,0x22,0x02,0x04}, // t
        {0x3c,0x02,0x02,0x04,0x3e}, // u
        {0x38,0x04,0x02,0x04,0x38}, // v
        {0x3c,0x02,0x0c,0x02,0x3c}, // w
        {0x22,0x14,0x08,0x14,0x22}, // x
        {0x30,0x0a,0x0a,0x0a,0x3c}, // y
        {0x22,0x26,0x2a,0x32,0x22}, // z
        {0x00,0x10,0x6c,0x82,0x00}, // {
        {0x00,0x00,0xfe,0x00,0x00}, // |
        {0x00,0x82,0x6c,0x10,0x00}, // }
        {0x40,0x80,0xc0,0x40,0x80}, // ~
        {0x00,0x00,0x00,0x00,0x00}, //
};


//-------- HT16K33 commands ---------
  #define HT16K33_CMD_SETUP   0x80
  #define HT16K33_CMD_DIMMING 0xE0 
  
//------- Value Setup for Command ---
  #define Osc_OFF      0x00
  #define Osc_ON       0x01
  #define DSP_OFF      0x00
  #define DSP_ON       0x01
  #define Blink_OFF    0x00
  #define Blink_2H     0x01
  #define Blink_1H     0x02
  #define Blink_0H5    0x03


const int I2C_Addr = 0x70; // HT16K33 default address
unsigned char dspBuf[16];
unsigned char BufOld[16];

 //------------- Setup --------------
void setup() 
{
 Serial.begin(9600);
  Wire.begin();  //Initial Start I2C 
  init_dsp()  ;

}



//================================= Main ================================
void loop() 
{
  int ct1=0,ct2=0,k  ;
  
  

   PrintStr("M",0)   ;   //Show String 1 charecter
   delay(2000)       ;
   
   PrintStr("OK",0)  ;   //Show String 2 charecter
   delay(2000)       ;


   PrintStr("ET-DSP I2C LED16x2",100)  ;  //Show String >2 charecter Shift Left
   delay(500);
   PrintStr("www.etteam.com",100)      ;  //Show String >2 charecter Shift Left 
   delay(500);
   
   Clr_buf(0)         ;     // Clear Display Buffer All 
   
   while(1)
    {
      //---------------Counter 0-99 ---------------  
      
      PrintChar(ct1,9)  ;     // Keep data to buffer dijit-unit
      Dsp_Show()        ;     //Show number digit-unit
      delay(600)        ;
      
      ct1++             ;     //Increment data digit-unit  
      if(ct1 > 9)             //check if colum unit>9 clear data digit unit =0 and increment data digit-10
        {      
          ct1=0             ; //Clear digit-unit=0
          PrintChar(ct1,9)  ; //keep data digit-unit to display buffer in position show  

         if(ct2==' ')         //Check data digit-10 if is space clear data to 0
            ct2 = 0         ;
            
          ct2++             ; //increment digit-10 step +1
          PrintChar(ct2,2)  ; //keep data digit-10 to display buffer in position show       
                   
          if(ct2>9)           //Check data digit-10 if > 9 Set data to Space
           {
             ct2= ' '          ; //Set data digit-10 to space=0x20 
             PrintChar(ct2,2)  ; //keep data digit-10 to display buffer in position show            
          
           }
        }
    
   } //while

}
 
 

//==================================== Sub-Program ==========================================

//***************************************************
//---------- Function Update Display All -------
//***************************************************

void Dsp_Show()
{
  int nd ;
  Wire.beginTransmission(I2C_Addr);
  Wire.write(0x00)                ; // start at address 0x0
 
  for (nd = 0; nd < 8; nd++) 
  {
    Wire.write(dspBuf[nd])       ; //Write data from buffer array 0-7  for Colum(0-7) address even   
    Wire.write(dspBuf[nd+8])     ; //Write data from buffer array 8-15 for Colum(8-15) address odd    
   
  }
  Wire.endTransmission();  
}

//*********************************************
// Function Initial Display
//*********************************************

void init_dsp()
 {
    Wire.beginTransmission(I2C_Addr)     ;
    Wire.write(0x20 | Osc_ON)            ; // turn on oscillator
    Wire.endTransmission()               ;

    DSP_OnOff(DSP_ON)   ;
    Dimmer(15)          ;     //Dimmer Max 
    Blink( Blink_OFF )  ;

    Clr_buf(0)          ;
    Dsp_Show()          ;
  
    delay(100)          ;

 }


//***********************************************************
//  Function Clear data Buffer of display All 
//        bg = Value data display buffer 0 or 1
//             0 : Data Buffer display all =0x00
//             1 : Data Buffer display all = 0xFF
//-*********************************************************
 
void Clr_buf(int bg)
{
  int nb ;

  if((bg==0)||(bg==1)) //Check bg is 0 or 1 only
   {
     if(bg == 0)
        bg = 0    ;
     else 
       bg = 0xFF  ;
  
    for( nb = 0 ; nb < 8; nb++)
     {
       dspBuf[nb]   = bg;  //Write data to buffer array 0-7  for Colum(0-7) address even   
       dspBuf[nb+8] = bg;  //Write data to buffer array 8-15 for Colum(8-15) address odd  
     }
     
  } //if bg
}

 //************************************************************
 // Function Sets the brightness of the display 
 //        dim = Value Brightness 0-15                      
 //************************************************************
 
void Dimmer(int dim)
 { 
  if(dim > 15) return;
  Wire.beginTransmission(I2C_Addr);
  Wire.write(HT16K33_CMD_DIMMING | dim); // Sent Dimming command
  Wire.endTransmission();
}

//***************************************************
 //Function Set display Blinking 
 //        bk = Value blink 0-3
 //             0=Blink off
 //             1=blink 2Hz    
 //             2=blink 1Hz 
 //             3=blink 0.5Hz                   
 //*************************************************

void Blink(int bk)
 {
  if(bk > 3) return;
 
  Wire.beginTransmission(I2C_Addr);
  Wire.write(HT16K33_CMD_SETUP | bk<<1 | DSP_ON ); //Sent blanking command
  Wire.endTransmission();
}

 //***************************************************
 // Function Set display On/Off 
 //        nf = Value ON/Off Display
 //             0=DSP OFF
 //             1=DSP ON               
 //*************************************************

void DSP_OnOff(int nf)
{
  Wire.beginTransmission(I2C_Addr);
  Wire.write(HT16K33_CMD_SETUP | nf); //Sent On/Off Display
  Wire.endTransmission();

}


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++              Function:Plot Text Ascii 1 Charecter                   ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++       Input :                                                       ++
  ++                  cha = Ascii Charecter (0x20-0x7F)                  ++
  ++                          or number 0-9                              ++
  ++                   px = Position colum Start plot Char 0-15          ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


 void PrintChar(unsigned char cha,char px)
 {
   unsigned char row,col,ft ;
  byte tx =0            ;
 
   if((cha>=0)&&(cha<=9))                  //if Data char is Number 0-9 
      cha = cha+0x30                   ;   // Convert Data is Ascii
                            
   row = cha-0x20                      ;   //Convert Ascii to value Position Start Array Row for charector

  //-----Set wide Font ------   
   ft = 5 ;                                           //Select font 5x7  ft= wide Byte :5 Byte
 
  for(col=0;col<ft;col++)                             //Loop Number Byte Charecter in 1 Row Array (wide charecter)
  {
     tx = pgm_read_byte(&font_5x7[row][col])        ;  //Read data font Charecter 5x7 
   
     dspBuf[px]  = tx  ;                               //keep data to display buffer
     px++              ;                               //increment array display buffer
  }

 }



/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++              Function:Plot Text  Shift                              ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  ++                                                                     ++
  ++       Input :                                                       ++
  ++                  cha = Ascii Charecter                              ++
  ++                                                                     ++
  +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


 void PrintShift(unsigned char cha,int ms)
 {
   unsigned char row,col,ft,k;
   byte tx =0            ;
 
   if((cha>=0)&&(cha<=9))                  //if Data char is Number 0-9 
      cha = cha+0x30                   ;   // Convert Data is Ascii
                            
   row = cha-0x20                      ;   //Convert Ascii to value Position Start Array Row for charector

  //-----Set wide Font ------   
   ft = 5 ;                                           //Select font 5x7  ft= wide Byte :5 Byte

 
  for(col=0;col<ft+1;col++)                             //Loop Number Byte Charecter in 1 Row Array (wide charecter)
  {
     tx = pgm_read_byte(&font_5x7[row][col])        ;  //Read data font Charecter 5x7 

     if(col>ft-1)                                       //เว้นวรรค 1 colum เมื่อจบ 1 ตัวอักษร
       tx=0 ;
       
     dspBuf[15]  = tx             ;                     //keep data to display buffer[15]
    
     for(k=0;k<15;k++)                                  //Shift data in display buffer from buf[15]---> buf[0]
      {
        dspBuf[k]  =  dspBuf[k+1] ;                 
      }
    
     Dsp_Show()          ;
     delay(ms);
   
  }

 }


 /*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ++                    Function:Print String                           ++
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ++                                                                    ++
   ++      Input  :                                                      ++
   ++               *str = Charecter ASCII (String)                      ++
   ++                ms  = Delay for text > 2 char unit ms               ++ 
   ++                                                                    ++
   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

void PrintStr(char *str,int ms)
{
  unsigned char i,num,k,cr ;

  num = strlen(str)        ;    //Read Leng of String
 
  Clr_buf(0)               ;     // Clear Display Buffer All
   
  if(num ==1)
   {
     PrintChar(str[0],9)  ;
     Dsp_Show()           ;    
   }  
  //--------------------------------------  
  
  if(num == 2) 
   {        
    PrintChar(str[0],2)  ; 
    PrintChar(str[1],9)  ; 

    Dsp_Show()        ;    

   }
  //------------------------------------   
  
  if(num > 2) 
  {
      
    for (i=0; str[i] != '\0'; i++)
     {          
       PrintShift(str[i],ms)  ;  //Read data Ascii Code of User and Plot to LED
     }   
     //------------------------------
    for(cr=0; cr<20;cr++)             //Loop shift clear display space when end last string
     {
       dspBuf[15] = 0               ; //Clear data buffer = 0
       for(k=0;k<15;k++)              //Shift data in display buffer from buf[15]---> buf[0]
        {
         dspBuf[k]  =  dspBuf[k+1] ;                 
        }
    
       Dsp_Show()                   ;
       delay(ms)                    ;
      
    } //for    
    
  } //if num
}//void

 




 
